/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.plant;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpecies;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesItem;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesType;

@Singleton
public class PlantSpeciesDictionary {
    public static final String COLOR_SWATCH_ASSET_PATH = "assets/definitions/entityAssets/plantColorSwatches/";
    private Map<String, PlantSpecies> byName = new HashMap<String, PlantSpecies>();
    private Map<PlantSpeciesType, List<PlantSpecies>> bySpeciesType = new HashMap<PlantSpeciesType, List<PlantSpecies>>();
    private List<PlantSpecies> allSpeciesList = new ArrayList<PlantSpecies>();

    @Inject
    public PlantSpeciesDictionary(GameMaterialDictionary materialDictionary, ItemTypeDictionary itemTypeDictionary) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        File speciesJsonFile = new File("assets/definitions/plantSpecies.json");
        List speciesList = (List)objectMapper.readValue(FileUtils.readFileToString(speciesJsonFile, "UTF-8"), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, PlantSpecies.class));
        for (PlantSpeciesType plantSpeciesType : PlantSpeciesType.values()) {
            this.bySpeciesType.put(plantSpeciesType, new ArrayList());
        }
        for (PlantSpecies plantSpecies : speciesList) {
            this.initialiseTransientFields(plantSpecies, materialDictionary, itemTypeDictionary);
            this.byName.put(plantSpecies.getSpeciesName(), plantSpecies);
            this.bySpeciesType.get((Object)plantSpecies.getPlantType()).add(plantSpecies);
            this.allSpeciesList.add(plantSpecies);
        }
    }

    public PlantSpecies getByName(String speciesName) {
        return this.byName.get(speciesName);
    }

    public List<PlantSpecies> getAll() {
        return this.allSpeciesList;
    }

    public List<PlantSpecies> getBySpeciesType(PlantSpeciesType speciesType) {
        return this.bySpeciesType.get((Object)speciesType);
    }

    private void initialiseTransientFields(PlantSpecies plantSpecies, GameMaterialDictionary materialDictionary, ItemTypeDictionary itemTypeDictionary) {
        PlantSpeciesItem plantItem;
        int x;
        if (plantSpecies.getLeafTransitionColorSwatch() != null && Gdx.graphics != null) {
            Pixmap transitionPixmap = new Pixmap(new FileHandle(COLOR_SWATCH_ASSET_PATH + plantSpecies.getLeafTransitionColorSwatch()));
            Array<Array<Color>> leafTransitionColors = plantSpecies.getLeafTransitionColors();
            for (int row = 0; row < transitionPixmap.getHeight(); ++row) {
                Array<Color> colorRow = new Array<Color>();
                for (int index = 0; index < transitionPixmap.getWidth(); ++index) {
                    colorRow.add(new Color(transitionPixmap.getPixel(index, row)));
                }
                leafTransitionColors.add(colorRow);
            }
            transitionPixmap.dispose();
        }
        if (plantSpecies.getLeafColorSwatch() != null && Gdx.graphics != null) {
            Pixmap leafColorPixmap = new Pixmap(new FileHandle(COLOR_SWATCH_ASSET_PATH + plantSpecies.getLeafColorSwatch()));
            for (int y = 0; y < leafColorPixmap.getHeight(); ++y) {
                for (x = 0; x < leafColorPixmap.getWidth(); ++x) {
                    plantSpecies.getLeafColors().add(new Color(leafColorPixmap.getPixel(x, y)));
                }
            }
            leafColorPixmap.dispose();
        }
        if (plantSpecies.getBranchColorSwatch() != null && Gdx.graphics != null) {
            Pixmap branchColorPixmap = new Pixmap(new FileHandle(COLOR_SWATCH_ASSET_PATH + plantSpecies.getBranchColorSwatch()));
            for (int y = 0; y < branchColorPixmap.getHeight(); ++y) {
                for (x = 0; x < branchColorPixmap.getWidth(); ++x) {
                    plantSpecies.getBranchColors().add(new Color(branchColorPixmap.getPixel(x, y)));
                }
            }
            branchColorPixmap.dispose();
        }
        if ((plantItem = plantSpecies.getItem()) != null) {
            ItemType itemType = itemTypeDictionary.getByName(plantItem.getItemTypeName());
            if (itemType == null) {
                throw new RuntimeException("Could not find item type " + plantItem.getItemTypeName() + " defined in " + plantSpecies.getSpeciesName());
            }
            plantItem.setItemType(itemType);
        }
        plantSpecies.setBranchMaterial(materialDictionary.getByName(plantSpecies.getBranchMaterial().getMaterialName()));
    }
}

